# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-111.
Решение на языке Python 3.
-------------------------------------------------
111) (ЕГЭ-2019) На вход программы поступает последовательность 
из N целых положительных чисел, все числа в последовательности 
различны. Рассматриваются все пары различных элементов 
последовательности, находящихся на расстоянии не менее, чем 4 
(разница в индексах элементов пары должна быть 4 или более, 
порядок элементов в паре неважен). Необходимо определить 
максимальную сумму пары чисел кратную 112, при этом первый 
элемент пары должен быть больше второго (a[i] > a[j], i < j).
Описание входных и выходных данных
В первой строке входных данных задаётся количество чисел N (5 ≤ N ≤ 1000). В каждой из после-дующих N строк записано одно целое положительное число, не превышающее 10 000.
Программа должна вывести в первой строке одно число: максимальную сумму пары элементов, находящихся в последовательности на расстоянии не менее чем 4, в которых сумма элементов кратна 112, а во второй строке – числа, образующие пару, через пробел. Если ни одной подходя-щей пары нет, нужно вывести одно число –1.
Входные данные: 
7 
119 
62 
35 
50 
48 
105 
274
Выходные данные: 
224
119 105
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/111.in")

sk = 112 # сумма д/б кратна sk
d = 4    # минимальная разница индексов
m = [0]*sk
queue = []
x = y = 0

n = int(input())     

for i in range(d):  # первые d элементов в очередь
  queue.append( int(input()) )

for i in range(d, n):
  first = queue[i % d] # выбрали первый из очереди
  k = first % sk
  if first > m[k]: 
    m[k] = first
  a = int(input())  # читаем следующий элемент
  k = a % sk        # и ищем ему пару  
  dk = (sk - k) % sk
  if m[dk] > a and (m[dk]+a > x+y): 
    x, y = m[dk], a
  queue[i % d] = a

if x > 0:
  print( x + y )
  print( x, y )
else:
  print( -1 )

sys.stdin = save_stdin