# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-114.
Решение на языке Python 3.
-------------------------------------------------
114) (Е. Джобс) На вход программы поступает последовательность 
из N целых положительных чисел, все числа в последовательности 
различны. Рассматриваются все пары различных элементов 
последовательности. Необходимо определить минимальную сумму 
пары чисел кратную 144, при этом первый элемент пары должен 
быть меньше второго (a[i] < a[j], i < j).
Описание входных и выходных данных
В первой строке входных данных задаётся количество чисел N 
(1 ≤ N ≤ 1000). В каждой из после-дующих N строк записано одно 
целое положительное число, не превышающее 12 000.
В качестве результата программа должна вывести последнюю 
найденную пару в последовательности с такой суммой или 0, 
если суммы с заданными характеристиками в последовательности 
нет.
Пример входных данных №1:
10
1
2
3
9
5
6
7
8
140
4
Выходные данных для примера №1:
0
Пример входных данных №2:
10
44
68
70
59
11
53
74
85
140
4
Выходные данных для примера №2:
59 85
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/114.in")

n = int(input())
a = [0]*144
mini, minj = 0, 0

for i in range(n):
    x = int(input())
    rem1 = x % 144
    rem2 = (144 - rem1) % 144   
    pair = a[rem2]
    if pair > 0 and pair < x and \
      (mini == 0 or pair + x <= mini + minj):
        mini, minj = pair, x
    if 0 == a[rem1] or a[rem1] >= x:
        a[rem1] = x

if mini != 0:
    print(mini, minj)
else:
    print(0)

sys.stdin = save_stdin