# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-60. 
Решение на языке Python 3.
 Автор: Константин Поляков, 2015
E-mail: kpolyakov@mail.ru
   Web: kpolyakov.spb.ru
-------------------------------------------------
На спутнике «Восход» установлен прибор, предназначенный для 
измерения солнечной активности. Каждую минуту прибор передаёт 
по каналу связи неотрицательное целое число – количество 
энергии солнечного излучения, полученной за последнюю минуту, 
измеренное в условных единицах. Временем, в течение которого 
происходит передача, можно пренебречь. Необходимо найти в 
заданной серии показаний прибора минимальное нечётное 
произведение двух показаний, между моментами передачи 
которых прошло не менее 6 минут. Если получить такое 
произведение не удаётся, ответ считается равным –1. Количество 
энергии, получаемое прибором за минуту, не превышает 
1000 условных единиц. Общее количество показаний прибора в 
серии не превышает 10 000.
Входные данные представлены следующим образом. В первой 
строке задаётся число N – общее количество показаний прибора. 
Гарантируется, что N > 6. В каждой из следующих N строк 
задаётся одно неотрицательное целое число – очередное показание прибора.
Пример входных данных:
11
12
45
5
3
17
23
21
20
19
12
26
Программа должна вывести одно число – 
описанную в условии сумму.
Пример выходных данных для приведённого выше 
примера входных данных:
95
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/60.in")

N = int(input())
K = 6
Buf = [0]*K
minOdd = 1000
minRes = 1000000
for i in range(N):
  if i >= K:
    if Buf[i % K] % 2 == 1:
      minOdd = min(minOdd, Buf[i % K])
  Buf[i % K] = int(input())
  if minOdd != 1000 and Buf[i % K] % 2 == 1:
    minRes = min(minRes, minOdd*Buf[i % K])

if minRes == 1000000:
  print(-1)
else:
  print(minRes)

sys.stdin = save_stdin