# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-63. 
Решение на языке Python 3.
 Автор: Константин Поляков, 2015
E-mail: kpolyakov@mail.ru
   Web: kpolyakov.spb.ru
-------------------------------------------------
На спутнике «Восход» установлен прибор, предназначенный для 
измерения солнечной активности. Каждую минуту прибор передаёт 
по каналу связи неотрицательное целое число – количество 
энергии солнечного излучения, полученной за последнюю минуту, 
измеренное в условных единицах. Временем, в течение которого 
происходит передача, можно пренебречь. Необходимо найти в 
заданной серии показаний прибора максимальное чётное 
произведение двух показаний, между моментами передачи 
которых прошло не менее 9 минут. Если получить такое 
произведение не удаётся, ответ считается равным –1. Количество 
энергии, получаемое прибором за минуту, не превышает 
1000 условных единиц. Общее количество показаний прибора в 
серии не превышает 10 000.
Входные данные представлены следующим образом. В первой 
строке задаётся число N – общее количество показаний прибора. 
Гарантируется, что N > 9. В каждой из следующих N строк 
задаётся одно неотрицательное целое число – очередное показание прибора.
Пример входных данных:
11
12
45
5
3
17
23
21
20
19
12
26
Программа должна вывести одно число – 
описанную в условии сумму.
Пример выходных данных для приведённого выше 
примера входных данных:
1170
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/63.in")

N = int(input())
K = 6
Buf = [0]*K
maxEven = -1
maxAll = -1
maxRes = -1
for i in range(N):
  if i >= K:
    if Buf[i % K] % 2 == 0:
      maxEven = max(maxEven, Buf[i % K])
    maxAll = max(maxAll, Buf[i % K])
  Buf[i % K] = int(input())
  if Buf[i % K] % 2 == 0:
    maxRes = max(maxRes, maxAll*Buf[i % K])
  else:
    maxRes = max(maxRes, maxEven*Buf[i % K])

print(maxRes)

sys.stdin = save_stdin